/*
 * CF30Window.h
 *
 *  Created on: 29.11.2012
 *      Author: georg
 */

#ifndef CF30WINDOW_H_
#define CF30WINDOW_H_

#include <iostream>
#include <dirent.h>
#include <gtkmm.h>
#include "MovementControl.h"
#include "SystemControl.h"

enum CF30_ERROR_Message_flag{
	CF30_ERROR_NO_FTDI_KERNELMODULE = 0,
	CF30_ERROR_CONNECTION_LOST,
	CF30_ERROR_COMPORT_IS_CLOSED
};

class CF30Window : public Gtk::Window{
public:
	CF30Window();
	virtual ~CF30Window();

	void setVoltageLabel(std::string text);

	int getVoltage();

	int updateInformationTreeView();

private:
	//Tree model columns:
	class ModelColumns : public Gtk::TreeModel::ColumnRecord {
	public:
		ModelColumns(){
			add(m_col_axis);
			add(m_col_velocity);
			add(m_col_position);
			add(m_col_step);
			add(m_col_ramp);
		}

		Gtk::TreeModelColumn<Glib::ustring> m_col_axis;
		Gtk::TreeModelColumn<int> m_col_velocity;
		Gtk::TreeModelColumn<int> m_col_position;
		Gtk::TreeModelColumn<Glib::ustring> m_col_step;
		Gtk::TreeModelColumn<int> m_col_ramp;
	};

	MovementControl movementControl;

	std::string singleStep_moveDirection_x;
	std::string singleStep_moveDirection_y;
	std::string singleStep_moveDirection_z;

	int velocityX;
	int velocityY;
	int velocityZ;

	bool set_x_toZero;
	bool set_y_toZero;
	bool set_z_toZero;

	Gtk::ScrolledWindow		m_information_table_scrolledWindow;

	Gtk::VBox				m_device_VBox;
	Gtk::VBox				m_single_step_VBox;
	Gtk::VBox				m_set_counter_VBox;
	Gtk::VBox				m_ramp_VBox;

	Gtk::HBox				m_single_step_x_HBox;
	Gtk::HBox				m_single_step_y_HBox;
	Gtk::HBox				m_single_step_z_HBox;
	Gtk::HBox				m_set_counter_x_HBox;
	Gtk::HBox				m_set_counter_y_HBox;
	Gtk::HBox				m_set_counter_z_HBox;
	Gtk::HBox				m_ramp_x_HBox;
	Gtk::HBox				m_ramp_y_HBox;
	Gtk::HBox				m_ramp_z_HBox;

	Gtk::Frame				m_scale_bar_frame;
	Gtk::Frame				m_stop_button_frame;
	Gtk::Frame				m_device_frame;
	Gtk::Frame				m_relative_move_frame;
	Gtk::Frame				m_single_step_frame;
	Gtk::Frame				m_absolute_move_frame;
	Gtk::Frame				m_set_counter_frame;
	Gtk::Frame				m_information_table_frame;
	Gtk::Frame				m_controler_information_frame;
	Gtk::Frame				m_ramp_frame;


	Gtk::Button				m_scan_button;
	Gtk::Button				m_open_button;
	Gtk::Button				m_close_button;
	Gtk::Button				m_movement_button_stop;
	Gtk::Button				m_move_relative_x_left;
	Gtk::Button				m_move_relative_y_left;
	Gtk::Button				m_move_relative_z_left;
	Gtk::Button				m_move_relative_x_right;
	Gtk::Button				m_move_relative_y_right;
	Gtk::Button				m_move_relative_z_right;
	Gtk::Button				m_move_single_step_x_right;
	Gtk::Button				m_move_single_step_y_right;
	Gtk::Button				m_move_single_step_z_right;
	Gtk::Button				m_move_single_step_x_left;
	Gtk::Button				m_move_single_step_y_left;
	Gtk::Button				m_move_single_step_z_left;
	Gtk::Button				m_move_absolute_position_x;
	Gtk::Button				m_move_absolute_position_y;
	Gtk::Button				m_move_absolute_position_z;
	Gtk::Button				m_set_counter_x;
	Gtk::Button				m_set_counter_y;
	Gtk::Button				m_set_counter_z;
	Gtk::Button				m_set_ramp_x;
	Gtk::Button				m_set_ramp_y;
	Gtk::Button				m_set_ramp_z;
	Gtk::Button				m_get_ramp_x;
	Gtk::Button				m_get_ramp_y;
	Gtk::Button				m_get_ramp_z;
	Gtk::Button				m_quit_button;

	Gtk::HScale				m_scale_bar_x;
	Gtk::HScale				m_scale_bar_y;
	Gtk::HScale				m_scale_bar_z;

	// dropdown menu
	Gtk::ComboBoxText		m_openDevice_textComboBox;

	// EntryBox
	Gtk::Entry				m_relative_move_velocity_x;
	Gtk::Entry				m_relative_move_velocity_y;
	Gtk::Entry				m_relative_move_velocity_z;
	Gtk::Entry				m_relative_move_steps_x;
	Gtk::Entry				m_relative_move_steps_y;
	Gtk::Entry				m_relative_move_steps_z;
	Gtk::Entry				m_absolute_move_velocity_x;
	Gtk::Entry				m_absolute_move_velocity_y;
	Gtk::Entry				m_absolute_move_velocity_z;
	Gtk::Entry				m_absolute_move_position_x;
	Gtk::Entry				m_absolute_move_position_y;
	Gtk::Entry				m_absolute_move_position_z;
	Gtk::Entry				m_set_counter_x_entrybox;
	Gtk::Entry				m_set_counter_y_entrybox;
	Gtk::Entry				m_set_counter_z_entrybox;
	Gtk::Entry				m_ramp_value_x;
	Gtk::Entry				m_ramp_value_y;
	Gtk::Entry				m_ramp_value_z;

	Gtk::Label				m_infoBox;
	Gtk::Label				m_voltage_label;
	Gtk::Label				m_relative_move_velocity_label;
	Gtk::Label				m_relative_move_steps_label;
	Gtk::Label				m_absolute_move_velocity_label;
	Gtk::Label				m_absolute_move_position_label;

	Gtk::TreeView			m_information_treeView;
	Glib::RefPtr<Gtk::ListStore> m_refTreeModel;
	ModelColumns 			m_Columns;

	Gtk::Grid				m_main_grid;
	Gtk::Grid				m_scaleBar_grid;
	Gtk::Grid				m_absolute_move_grid;
	Gtk::Grid				m_relative_move_grid;

	void init_widgets();
	void attach_widgets_to_table();
	void connect_widgets_with_frames();
	void connect_signals();
	void check_connected_controller();

	void on_scan_button_clicked();
	void on_open_button_clicked();
	void on_movement_button_stop_clicked();

	void on_move_relative_x_left_clicked();
	void on_move_relative_y_left_clicked();
	void on_move_relative_z_left_clicked();
	void on_move_relative_x_right_clicked();
	void on_move_relative_y_right_clicked();
	void on_move_relative_z_right_clicked();

	void on_move_single_step_x_right_clicked();
	void on_move_single_step_y_right_clicked();
	void on_move_single_step_z_right_clicked();
	void on_move_single_step_x_left_clicked();
	void on_move_single_step_y_left_clicked();
	void on_move_single_step_z_left_clicked();

	void on_move_absolute_position_x_clicked();
	void on_move_absolute_position_y_clicked();
	void on_move_absolute_position_z_clicked();

	void on_set_counter_x_clicked();
	void on_set_counter_y_clicked();
	void on_set_counter_z_clicked();

	void on_set_ramp_x_clicked();
	void on_set_ramp_y_clicked();
	void on_set_ramp_z_clicked();
	void on_get_ramp_x_clicked();
	void on_get_ramp_y_clicked();
	void on_get_ramp_z_clicked();

	void on_close_button_clicked();
	void on_quit_button_clicked();

	void scale_bar_x_moved();
	void scale_bar_y_moved();
	void scale_bar_z_moved();
	bool scaleBar_x_released(GdkEventButton* event);
	bool scaleBar_x_pressed(GdkEventButton* event);
	bool scaleBar_y_released(GdkEventButton* event);
	bool scaleBar_y_pressed(GdkEventButton* event);
	bool scaleBar_z_released(GdkEventButton* event);
	bool scaleBar_z_pressed(GdkEventButton* event);

	void relativeMoveVelocity_checkInput_x();
	void relativeMoveVelocity_checkInput_y();
	void relativeMoveVelocity_checkInput_z();
	void relativeMoveSteps_checkInput_x();
	void relativeMoveSteps_checkInput_y();
	void relativeMoveSteps_checkInput_z();

	void absoluteMoveVelocity_checkInput_x();
	void absoluteMoveVelocity_checkInput_y();
	void absoluteMoveVelocity_checkInput_z();
	void absoluteMovePosition_checkInput_x();
	void absoluteMovePosition_checkInput_y();
	void absoluteMovePosition_checkInput_z();

	void setCounter_checkInput_x();
	void setCounter_checkInput_y();
	void setCounter_checkInput_z();

	void rampValue_checkInput_x();
	void rampValue_checkInput_y();
	void rampValue_checkInput_z();

	std::string checkForNumericInput(std::string input, int maxValue);

	void errorMessageOutput(CF30_ERROR_Message_flag messageFlag);
};

#endif /* CF30WINDOW_H_ */
